//
//  MCCreateAndEditWindowController.h
//  MCApplication
//
//  Created by Michael Clark on 30/03/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCWindowController.h"

@class MCCreateAndEditAbstractView;

enum
{
	MCCREATE_AND_EDIT_WINDOWCONTROLLER_CANCEL_BUTTON = 0,
	MCCREATE_AND_EDIT_WINDOWCONTROLLER_OK_BUTTON = 1
};

#define MCCREATEANDEDITWINDOWCONTROLLER_WIDTH_PADDING   40.0
#define MCCREATEANDEDITWINDOWCONTROLLER_HEIGHT_PADDING  64.0

@class MCHelpController;
@interface MCCreateAndEditWindowController : MCWindowController {
	id                                         _object;
    id                                         _cloneObject;
	
    BOOL                                       _editingObject;
    
    IBOutlet NSObjectController*  filesOwnerController;
    
	IBOutlet MCCreateAndEditAbstractView*      view;
	IBOutlet NSBox*                            createAuxView;
	IBOutlet NSButton*                         okButton;
	
    IBOutlet NSTextField*                      nextStepTextField;
    IBOutlet NSPopUpButton*                    nextStepPopUp;
    
	IBOutlet NSView                           *accessoryContainerView;
	IBOutlet NSButton                         *helpButton;
	
	NSArray*                                   _preLinkedObjects;
	id                                         _preCreatedObject; // if it's a create card but the object is created by someone else and passed in
    
    BOOL objectLocked;
    BOOL noWriteAccess;
    
    BOOL shouldAddToObjectContext;  // this is a hack...
    
	BOOL __didCancel; // this bool is set to yes if the user pressed cancel
	BOOL __didOK;     // this bool is set to yes if the user pressed ok
	
	NSUndoManager *_undoManager;
    /*
     We have this shouldAddToObjectContext flag which basically means we can shut off the create
     cards desire to add the object to the object context when performing saveObject: if the object
     isn't already persistent.  We need to satisfy this case when we create an LineItem for instance
     in the Opportunity create card.  We don't want the line item to be created if the user clicks
     Cancel on the Create Opportunity card.  So, if we don't add the LineItem, it will get added when
     the user clicks Ok/Save for the Create Opportunity card.  This is the desired effect.  This works
     well, the only "sketchy" thing is what will happen if you are creating objects which have things
     linked to them (this won't propagate correctly).  Therefore, only use this for simple objects, 
     ie. LineItem, etc.  (things which don't get linked to a bunch of stuff, ie. Contact).  It might
     work, but no guarantees.
     */
}

- (BOOL)objectLocked;
- (void)setObjectLocked:(BOOL)flag;
- (BOOL)noWriteAccess;
- (void)setNoWriteAccess:(BOOL)flag;
- (BOOL)shouldAddToObjectContext;
- (void)setShouldAddToObjectContext:(BOOL)flag;

- (id)object;
- (void)setObject:(id)anObject;

- (id)cloneObject;
- (void)setCloneObject:(id)aCloneObject;


- (NSArray *)preLinkedObjects;
- (void)setPreLinkedObjects:(NSArray *)aPreLinkedObjects;

- (id)preCreatedObject;
- (void)setPreCreatedObject:(id)aPreCreatedObject;


- (BOOL)isAnotherCreateEditWindowOpen;

- (MCCreateAndEditAbstractView *)view;

- (BOOL)checkAndWarnAboutChanges;

// Called before anything happens in the next two methods - subclassers and do stuff by overriding this
- (void)initialSetupForEntityName: (NSString*)entityName;

- (void)runForEntityNamed: (NSString*)name initialValues: (NSDictionary*)initialValues linkToObjects: (NSArray*)objects;

- (void)runForObject: (id)object linkToObjects: (NSArray*)objects;
- (void)runForObject: (id)object 
       linkToObjects: (NSArray*)objects 
withPreferredViewNamed:(NSString*)aViewName
            autosave:(BOOL)shouldAutosave;


- (void)runForEntityNamed: (NSString*)name initialValues: (NSDictionary*)initialValues linkToObjects: (NSArray*)objects withPreferredViewNamed:(NSString*)aViewName;
- (void)runForObject: (id)object linkToObjects: (NSArray*)objects withPreferredViewNamed:(NSString*)aViewName;

- (void)setupForEntityNamed: (NSString*)name initialValues: (NSDictionary*)initialValues linkToObjects: (NSArray*)objects;

- (void)setupForObject: (id)object linkToObjects: (NSArray*)objects;

- (void)setupForEntityNamed: (NSString*)name initialValues: (NSDictionary*)initialValues linkToObjects: (NSArray*)objects withPreferredViewNamed:(NSString*)aName;

- (void)setupForObject: (id)object linkToObjects: (NSArray*)objects withPreferredViewNamed:(NSString*)aName;
- (void)setupForObject: (id)object 
         linkToObjects: (NSArray*)objects
withPreferredViewNamed:(NSString*)aName
              autosave:(BOOL)shouldAutosave;


- (void)_setupViewForEntityNamed: (NSString*)name withPreferredViewNamed:(NSString*)aViewName;
- (void)_setupViewForEntityNamed: (NSString*)name 
          withPreferredViewNamed:(NSString*)aViewName 
                        autosave:(BOOL)shouldAutosave;


- (BOOL)editingObject;

- (IBAction)saveObject: (id)sender;
- (IBAction)cancelObject: (id)sender;

- (NSTextField*)nextStepTextField;
- (NSPopUpButton*)nextStepPopUp;
- (NSView *)accessoryContainerView;

- (NSButton *)helpButton;

- (void)linkObject:(id)anObj toObjects:(NSArray*)linkToObjects;

- (void)propagateChangedToManyRelationships;

@end
